#include <bits/stdc++.h>
#pragma optimize("O3, unroll-loops")
#pragma target("avx2, bmi, bmi2, lzcnt, popcnt")

#define ll long long 

using namespace std;

int is_swapped_pair(int k, const vector<int>& card_idx_arr, int n_cards) {
    if (k < 1 || k >= n_cards) return 0;
    if (card_idx_arr[k] > card_idx_arr[k+1]) {
        return 1;
    }
    return 0;
}

void solve() {
    int n, q;
    cin >> n >> q;

    vector<int> a(n);
    vector<int> card_idx(n + 1);

    for (int i = 0; i < n; ++i) {
        cin >> a[i];
        card_idx[a[i]] = i;
    }

    int cost = 0;
    for (int k = 1; k < n; ++k) { 
        if (card_idx[k] > card_idx[k+1]) {
            cost++;
        }
    }
    cout << cost << "\n";

    for (int qi = 0; qi < q; ++qi) {
        int raw_p1, raw_p2;
        cin >> raw_p1 >> raw_p2;
        int p1 = raw_p1 - 1;
        int p2 = raw_p2 - 1;

        if (p1 == p2) {
            cout << cost << "\n";
            continue;
        }

        int card_at_p1 = a[p1];
        int card_at_p2 = a[p2];

        set<int> check_these_cards;        
        if (card_at_p1 > 1) check_these_cards.insert(card_at_p1 - 1);
        if (card_at_p1 < n) check_these_cards.insert(card_at_p1);
        
        if (card_at_p2 > 1) check_these_cards.insert(card_at_p2 - 1);
        if (card_at_p2 < n) check_these_cards.insert(card_at_p2);

        for (int card_val : check_these_cards) {
            cost -= is_swapped_pair(card_val, card_idx, n);
        }

        swap(a[p1], a[p2]);
        card_idx[card_at_p1] = p2;
        card_idx[card_at_p2] = p1;
        
        for (int card_val : check_these_cards) {
            cost += is_swapped_pair(card_val, card_idx, n);
        }
        cout << cost << "\n";
    }
}

int main() {
    ios::sync_with_stdio(false); cin.tie(0); cout.tie(0);
    solve();
    return 0;
}